/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui;

import java.awt.CheckboxMenuItem;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.LauncherConsole;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.GameUtils;
import net.ftb.util.OSUtils;

public class TrayMenu
extends PopupMenu {
    private static final long serialVersionUID = 1L;
    private final MenuItem killMCButton = new MenuItem(){
        {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GameUtils.killMC();
                }
            });
        }
    };
    private final MenuItem quitButton = new MenuItem(){
        {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    System.exit(0);
                }
            });
        }
    };
    private final MenuItem ftbWebsite = new MenuItem(){
        {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    OSUtils.browse("http://www.feed-the-beast.com");
                }
            });
        }
    };
    private final CheckboxMenuItem showConsole = new CheckboxMenuItem(){
        {
            if (LaunchFrame.con != null) {
                this.setState(LaunchFrame.con.isVisible());
            } else {
                this.setState(false);
            }
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean state = TrayMenu.this.showConsole.getState();
                    if (LaunchFrame.con != null) {
                        if (state) {
                            LaunchFrame.con.setVisible(true);
                            Logger.addListener(LaunchFrame.con);
                        } else {
                            LaunchFrame.con.setVisible(false);
                            Logger.removeListener(LaunchFrame.con);
                        }
                    } else {
                        LaunchFrame.con = new LauncherConsole();
                        LaunchFrame.con.setVisible(true);
                        Logger.addListener(LaunchFrame.con);
                    }
                }
            });
        }
    };

    public TrayMenu() {
        this.killMCButton.setLabel(I18N.getLocaleString("KILL_MC"));
        this.quitButton.setLabel(I18N.getLocaleString("TRAY_QUIT"));
        this.ftbWebsite.setLabel(I18N.getLocaleString("TRAY_FTB_WEBSITE"));
        this.showConsole.setLabel(I18N.getLocaleString("SHOW_CONSOLE"));
        this.add(this.killMCButton);
        this.addSeparator();
        this.add(this.showConsole);
        this.addSeparator();
        this.add(this.ftbWebsite);
        this.add(this.quitButton);
    }

    public void updateLocale() {
        this.killMCButton.setLabel(I18N.getLocaleString("KILL_MC"));
        this.quitButton.setLabel(I18N.getLocaleString("TRAY_QUIT"));
        this.ftbWebsite.setLabel(I18N.getLocaleString("TRAY_FTB_WEBSITE"));
        this.showConsole.setLabel(I18N.getLocaleString("SHOW_CONSOLE"));
    }

    public void updateShowConsole(boolean b) {
        this.showConsole.setState(b);
    }
}

